/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.arm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.arm.ARMProcessor;
import jpcsp.memory.mmio.IMMIOHandler;
import jpcsp.memory.mmio.MMIO;
import jpcsp.memory.mmio.MMIOHandlerReadWrite;
import jpcsp.memory.mmio.wlan.MMIOHandlerWlanFirmware;
import jpcsp.memory.mmio.wlan.MMIOHandlerWlanFirmware2;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class ARMMemory
extends MMIO {
    public static Logger log = ARMProcessor.log;
    public static final int SIZE_RAM0 = 98304;
    public static final int BASE_RAM0 = 0;
    public static final int END_RAM0 = 98303;
    public static final int SIZE_RAM4 = 8192;
    public static final int BASE_RAM4 = 0x4000000;
    public static final int END_RAM4 = 67117055;
    public static final int SIZE_HANDLER8 = 65536;
    public static final int BASE_HANDLER8 = Integer.MIN_VALUE;
    public static final int END_HANDLER8 = -2147418113;
    public static final int SIZE_HANDLER9 = 65536;
    public static final int BASE_HANDLER9 = -1879048192;
    public static final int END_HANDLER9 = -1878982657;
    public static final int SIZE_RAMC = 98304;
    public static final int BASE_RAMC = -1073741824;
    public static final int END_RAMC = -1073643521;
    public static final int SIZE_ROMF = 65536;
    public static final int BASE_ROMF = -65536;
    public static final int END_ROMF = -1;
    private final ARMBackendMemory backendMemory = (ARMBackendMemory)this.getBackendMemory();
    private final int[] ram0 = new int[24576];
    private ARMMMIOHandlerReadWrite ram0Handler = new ARMMMIOHandlerReadWrite(0, 98304, this.ram0);
    private final int[] ram4;
    private ARMMMIOHandlerReadWrite ram4Handler;
    private MMIOHandlerWlanFirmware handlerWlanFirmware;
    private MMIOHandlerWlanFirmware2 handlerWlanFirmware2;
    private final int[] ramC;
    private ARMMMIOHandlerReadWrite ramCHandler;
    private final int[] romF;
    private ARMMMIOHandlerReadWrite romFHandler;

    public ARMMemory(Logger log) {
        super(new ARMBackendMemory());
        this.ram0Handler.setLogger(log);
        this.ram4 = new int[2048];
        this.ram4Handler = new ARMMMIOHandlerReadWrite(0x4000000, 8192, this.ram4);
        this.ram4Handler.setLogger(log);
        this.handlerWlanFirmware = new MMIOHandlerWlanFirmware(Integer.MIN_VALUE);
        this.handlerWlanFirmware2 = new MMIOHandlerWlanFirmware2(-1879048192, this.handlerWlanFirmware);
        this.ramC = new int[24576];
        this.ramCHandler = new ARMMMIOHandlerReadWrite(-1073741824, 98304, this.ramC);
        this.ramCHandler.setLogger(log);
        this.romF = new int[16384];
        this.romFHandler = new ARMMMIOHandlerReadWrite(-65536, 65536, this.romF);
        this.romFHandler.setLogger(log);
    }

    public void setProcessor(ARMProcessor processor) {
        this.backendMemory.setProcessor(processor);
        this.ram0Handler.setProcessor(processor);
        this.ram4Handler.setProcessor(processor);
        this.handlerWlanFirmware.setProcessor(processor);
        this.handlerWlanFirmware2.setProcessor(processor);
        this.ramCHandler.setProcessor(processor);
        this.romFHandler.setProcessor(processor);
    }

    public MMIOHandlerWlanFirmware getHandlerWlanFirmware() {
        return this.handlerWlanFirmware;
    }

    @Override
    protected IMMIOHandler getHandler(int address) {
        if (address >= 0 && address <= 98303) {
            return this.ram0Handler;
        }
        if (address >= 0x4000000 && address <= 67117055) {
            return this.ram4Handler;
        }
        if (address >= Integer.MIN_VALUE && address <= -2147418113) {
            return this.handlerWlanFirmware;
        }
        if (address >= -1879048192 && address <= -1878982657) {
            return this.handlerWlanFirmware2;
        }
        if (address >= -1073741824 && address <= -1073643521) {
            return this.ramCHandler;
        }
        if (address >= -65536 && address <= -1) {
            return this.romFHandler;
        }
        return super.getHandler(address);
    }

    public static boolean isAddressGood(int address) {
        if (address >= 0 && address <= 98303) {
            return true;
        }
        if (address >= 0x4000000 && address <= 67117055) {
            return true;
        }
        if (address >= Integer.MIN_VALUE && address <= -2147418113) {
            return true;
        }
        if (address >= -1879048192 && address <= -1878982657) {
            return true;
        }
        if (address >= -1073741824 && address <= -1073643521) {
            return true;
        }
        return address >= -65536 && address <= -1;
    }

    private static class ARMBackendMemory
    extends Memory {
        private ARMProcessor processor;

        public void setProcessor(ARMProcessor processor) {
            this.processor = processor;
        }

        private void invalidMemoryAddress(int address, String value, String prefix, int status) {
            log.error((Object)String.format("0x%08X - %s - Invalid memory address: 0x%08X%s", this.processor.getCurrentInstructionPc(), prefix, address, value));
            if (!Settings.getInstance().readBool("emu.ignoreInvalidMemoryAccess")) {
                Emulator.PauseEmuWithStatus(status);
            }
        }

        @Override
        public void invalidMemoryAddress(int address, String prefix, int status) {
            this.invalidMemoryAddress(address, "", prefix, status);
        }

        @Override
        public void invalidMemoryAddress(int address, int length, String prefix, int status) {
            log.error((Object)String.format("0x%08X - %s - Invalid memory address: 0x%08X-0x%08X(length=0x%X)", this.processor.getCurrentInstructionPc(), prefix, address, address + length, length));
            if (!Settings.getInstance().readBool("emu.ignoreInvalidMemoryAccess")) {
                Emulator.PauseEmuWithStatus(status);
            }
        }

        @Override
        public void Initialise() {
        }

        @Override
        public int read8(int address) {
            this.invalidMemoryAddress(address, "read8", 4);
            return 0;
        }

        @Override
        public int read16(int address) {
            this.invalidMemoryAddress(address, "read16", 4);
            return 0;
        }

        @Override
        public int read32(int address) {
            this.invalidMemoryAddress(address, "read32", 4);
            return 0;
        }

        @Override
        public void write8(int address, byte data) {
            this.invalidMemoryAddress(address, String.format(" (0x%02X)", data & 0xFF), "write8", 8);
        }

        @Override
        public void write16(int address, short data) {
            this.invalidMemoryAddress(address, String.format(" (0x%04X)", data & 0xFFFF), "write16", 8);
        }

        @Override
        public void write32(int address, int data) {
            this.invalidMemoryAddress(address, String.format(" (0x%08X)", data), "write32", 8);
        }

        @Override
        public void memset(int address, byte data, int length) {
            this.invalidMemoryAddress(address, length, "memset", 8);
        }

        @Override
        public Buffer getMainMemoryByteBuffer() {
            return null;
        }

        @Override
        public Buffer getBuffer(int address, int length) {
            this.invalidMemoryAddress(address, length, "getBuffer", 4);
            return null;
        }

        @Override
        public void copyToMemory(int address, ByteBuffer source, int length) {
            this.invalidMemoryAddress(address, length, "copyToMemory", 8);
        }

        @Override
        protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
            this.invalidMemoryAddress(destination, length, "memcpy", 8);
        }
    }

    private static class ARMMMIOHandlerReadWrite
    extends MMIOHandlerReadWrite {
        private ARMProcessor processor;

        public ARMMMIOHandlerReadWrite(int baseAddress, int length, int[] memory) {
            super(baseAddress, length, memory);
        }

        public void setProcessor(ARMProcessor processor) {
            this.processor = processor;
        }

        @Override
        protected int getPc() {
            return this.processor.getCurrentInstructionPc();
        }
    }
}

